/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.IntegerJTextField;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class IncrementableIntegerJTextField
extends IntegerJTextField {
    protected int increment;
    protected Key keyListener = null;

    public IncrementableIntegerJTextField() {
        this.setMin(0);
        this.setMax(100);
        this.setIncrement(1);
        this.setValue(0);
    }

    public synchronized void addNotify() {
        if (this.keyListener == null) {
            this.keyListener = new Key();
            this.addKeyListener(this.keyListener);
        }
        super.addNotify();
    }

    public boolean checkValue() {
        boolean rw = true;
        int value = this.getValue();
        if (value > this.fMaximum || value < this.fMinimum) {
            rw = false;
        } else if ((value - this.getMin()) % this.getIncrement() != 0) {
            rw = false;
        }
        if (!rw && this.errorMessage != null) {
            this.errorMessage.display();
        }
        return rw;
    }

    public boolean checkValue(boolean notify) {
        boolean result = true;
        int value = this.getValue();
        if (value > this.fMaximum || value < this.fMinimum) {
            result = false;
        } else if ((value - this.getMin()) % this.getIncrement() != 0) {
            result = false;
        }
        if (notify && !result) {
            this.getError().display();
            this.requestFocus();
        }
        return result;
    }

    public LogoError createDefaultError() {
        if (this.getIncrement() == 1) {
            return this.createError("error.dialog.invalidValue", "Please enter an Integer between " + this.getMin() + " and " + this.getMax() + " .");
        }
        return this.createError("error.dialog.invalidValueIncrement", "Please enter an Integer between " + this.getMin() + " and " + this.getMax() + " by increment of " + this.getIncrement() + ".");
    }

    public LogoError createError(String ErrorKey, String DefaultErrorText) {
        Object[] parameters = new Object[]{new Integer(this.getMin()), new Integer(this.getMax()), new Integer(this.getIncrement())};
        return new LogoError((Component)this, ErrorKey, DefaultErrorText, parameters, 2, 0);
    }

    public void Dec() {
        int i = this.getValue();
        if ((i -= this.getIncrement()) > this.getMax()) {
            i = this.getMax();
        }
        if (i < this.getMin()) {
            i = this.getMin();
        }
        if ((i - this.getMin()) % this.getIncrement() != 0) {
            i += this.getIncrement();
            i = (i - this.getMin()) / this.getIncrement() * this.getIncrement() + this.getMin();
        }
        this.setValue(i);
    }

    public int getIncrement() {
        return this.increment;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void Inc() {
        int i = this.getValue();
        if ((i += this.getIncrement()) > this.getMax()) {
            i = this.getMax();
        }
        if (i < this.getMin()) {
            i = this.getMin();
        }
        if ((i - this.getMin()) % this.getIncrement() != 0) {
            i = (i - this.getMin()) / this.getIncrement() * this.getIncrement() + this.getMin();
        }
        this.setValue(i);
    }

    protected void processUpDown(int key) {
        if (key == 38) {
            this.Inc();
            return;
        }
        if (key == 40) {
            this.Dec();
            return;
        }
    }

    public synchronized void removeNotify() {
        if (this.keyListener != null) {
            this.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        super.removeNotify();
    }

    public void setIncrement(int inc) {
        int current = this.getValue();
        this.increment = inc;
        if ((current - this.getMin()) / inc * inc + this.getMin() != current) {
            if ((current = (current - this.getMin()) / inc * inc + this.getMin()) < this.getMin()) {
                current = this.getMin();
            }
            this.setValue(current);
        }
    }

    public void setValue(int value) {
        int value1 = this.increment > 1 ? value / this.increment * this.increment : value;
        value1 = this.getCorrectValue(value1);
        super.setText(Integer.toString(value1));
    }

    class Key
    extends KeyAdapter {
        Key() {
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 38: 
                case 40: {
                    IncrementableIntegerJTextField.this.processUpDown(key);
                }
            }
        }
    }
}

